<?php
require __DIR__ . '/../inc/bootstrap.php';
header('Content-Type: application/json; charset=utf-8');
$type = $_GET['type'] ?? '';
$q = trim($_GET['q'] ?? '');
$results = [];
if ($q === '' || $type === '') { echo json_encode([]); exit; }
switch ($type) {
  case 'doctor':
    $stmt = $pdo->prepare("SELECT id, nombre, rut, especialidad FROM doctores WHERE nombre LIKE ? OR rut LIKE ? ORDER BY nombre LIMIT 10");
    $stmt->execute(["%$q%", "%$q%"]);
    foreach ($stmt as $r) { $results[] = ['id'=>(int)$r['id'],'label'=>$r['nombre']." (".$r['rut'].")",'nombre'=>$r['nombre'],'rut'=>$r['rut'],'especialidad'=>$r['especialidad']]; }
    break;
  case 'paciente':
    $stmt = $pdo->prepare("SELECT id, nombre, rut, direccion, telefono, mascota FROM pacientes WHERE nombre LIKE ? OR rut LIKE ? ORDER BY nombre LIMIT 10");
    $stmt->execute(["%$q%", "%$q%"]);
    foreach ($stmt as $r) { $results[] = ['id'=>(int)$r['id'],'label'=>$r['nombre']." (".$r['rut'].")",'nombre'=>$r['nombre'],'rut'=>$r['rut'],'direccion'=>$r['direccion'],'telefono'=>$r['telefono'],'mascota'=>$r['mascota']]; }
    break;
  case 'componente':
    $stmt = $pdo->prepare("SELECT id, nombre, precio_venta_g, estado FROM componentes WHERE nombre LIKE ? ORDER BY nombre LIMIT 10");
    $stmt->execute(["%$q%"]);
    foreach ($stmt as $r) { $results[] = ['id'=>(int)$r['id'],'label'=>$r['nombre'],'nombre'=>$r['nombre'],'precio_venta_g'=>(float)$r['precio_venta_g'],'estado'=>$r['estado']]; }
    break;
}
echo json_encode($results);