<?php
require_once __DIR__ . '/inc/bootstrap.php';
require_once __DIR__ . '/inc/auth.php';
require_login();
$u = current_user();
?>
<!doctype html><html lang='es'><head>
  <meta charset='utf-8'>
  <meta name='viewport' content='width=device-width,initial-scale=1'>
  <link rel='stylesheet' href='assets/styles.css'>
  <link rel='stylesheet' href='assets/theme.css'>
  <title>Farmacia · Recetario</title>
  <style>
    .topbar{display:flex;justify-content:space-between;align-items:center;margin-bottom:8px}
    .topbar .who{font-size:14px;color:#334155}
    .theme-prep .nav .btn.btn-doc{background:#10b981!important;color:#053321!important;border:none}
    .theme-prep .nav .btn.btn-doc:hover{background:#0ea371!important}
    .theme-prep .nav .btn.btn-pac{background:#f59e0b!important;color:#3b1f00!important;border:none}
    .theme-prep .nav .btn.btn-pac:hover{background:#d98705!important}
    .theme-prep .nav .btn.btn-comp{background:#6366f1!important;color:#11113a!important;border:none}
    .theme-prep .nav .btn.btn-comp:hover{background:#4f52e6!important}
  </style>
</head><body>
<div class='container'>
  <div class='card theme-prep'>
    <div class="topbar">
      <h1 style='margin:0'>Farmacia · Recetario Magistral</h1>
      <div class="who">
        <?= htmlspecialchars($u['username'] ?? ''); ?>
        <?php if (!empty($u['rol'])): ?> · <?= htmlspecialchars($u['rol']); ?><?php endif; ?>
        &nbsp;|&nbsp;<a class="btn" href="logout.php">Cerrar sesión</a>
      </div>
    </div>

    <div class='nav' style='margin-top:12px'>
      <a class='btn' href='pages/preparados/create.php'>➕ Preparado nuevo</a>
      <a class='btn' href='pages/preparados/list.php'>🧾 Listado de preparados</a>
      <a class='btn btn-doc'  href='pages/doctores/index.php'>👨‍⚕️ Doctores</a>
      <a class='btn btn-pac'  href='pages/pacientes/index.php'>🧍 Pacientes</a>
      <a class='btn btn-comp' href='pages/componentes/index.php'>🧪 Componentes</a>
      <a class='btn' href='pages/tools/backup.php'>💾 Respaldo BD (SQL)</a>
    </div>
  </div>
</div>
</body></html>
