
<?php
require_once __DIR__ . '/inc/bootstrap.php';
require_once __DIR__ . '/inc/auth.php';
if (is_logged_in()) { header('Location: index.php'); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $user = trim($_POST['username'] ?? '');
  $pass = $_POST['password'] ?? '';
  if (attempt_login($user, $pass)) {
    header('Location: index.php'); exit;
  } else {
    $error = 'Usuario o contraseña incorrectos, o usuario inactivo.';
  }
}
?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="assets/styles.css"><link rel="stylesheet" href="assets/theme.css">
<title>Ingresar</title>
</head><body>
<div class="container mini">
  <div class="card">
    <h2>Ingreso</h2>
    <?php if ($error): ?><div class="alert alert-danger"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
      <div class="label">Usuario</div>
      <input class="input" name="username" required autofocus>
      <div class="label" style="margin-top:8px">Contraseña</div>
      <input class="input" type="password" name="password" required>
      <div style="margin-top:12px">
        <button class="btn" type="submit">Entrar</button>
      </div>
    </form>
  </div>
</div>
</body></html>
