<?php
// public/pages/ajax/find_or_create_doctor.php
require __DIR__.'/../../inc/bootstrap.php';
header('Content-Type: application/json; charset=utf-8');

try {
  // Datos desde POST (o JSON)
  $in = $_POST;
  if (empty($in)) {
    $raw = file_get_contents('php://input');
    if ($raw) { $tmp = json_decode($raw, true); if (is_array($tmp)) $in = $tmp; }
  }

  $nombre       = trim($in['nombre'] ?? '');
  $rut          = trim($in['rut'] ?? '');
  $especialidad = trim($in['especialidad'] ?? '');
  $direccion    = trim($in['direccion'] ?? '');
  $telefono     = trim($in['telefono'] ?? '');

  if ($nombre === '' && $rut === '') {
    echo json_encode(['ok'=>false, 'error'=>'Faltan nombre o RUT']); exit;
  }

  // 1) Buscar por RUT si viene
  if ($rut !== '') {
    $s = $pdo->prepare("SELECT id, nombre, rut FROM doctores WHERE rut=? LIMIT 1");
    $s->execute([$rut]);
    $found = $s->fetch();
    if ($found) {
      echo json_encode(['ok'=>true, 'id'=>(int)$found['id'], 'nombre'=>$found['nombre'], 'rut'=>$found['rut'], 'created'=>false]); exit;
    }
  }

  // 2) Si no hay RUT o no existe, intento por nombre exacto
  if ($nombre !== '') {
    $s = $pdo->prepare("SELECT id, nombre, rut FROM doctores WHERE nombre=? LIMIT 1");
    $s->execute([$nombre]);
    $found = $s->fetch();
    if ($found) {
      echo json_encode(['ok'=>true, 'id'=>(int)$found['id'], 'nombre'=>$found['nombre'], 'rut'=>$found['rut'], 'created'=>false]); exit;
    }
  }

  // 3) Crear
  $i = $pdo->prepare("INSERT INTO doctores (nombre, rut, especialidad, direccion, telefono) VALUES (?,?,?,?,?)");
  $i->execute([$nombre, $rut, $especialidad, $direccion, $telefono]);
  $id = (int)$pdo->lastInsertId();

  echo json_encode(['ok'=>true, 'id'=>$id, 'nombre'=>$nombre, 'rut'=>$rut, 'created'=>true]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
