<?php require __DIR__.'/../../inc/bootstrap.php'; ?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../../assets/styles.css">
<link rel="stylesheet" href="../../assets/theme.css">
<title>Componentes</title></head><body>
<div class="container"><div class="card theme-comp">
  <a class="btn" href="../../index.php">&larr; Inicio</a>
  <h2>Componentes</h2>
  <div style="display:flex;gap:8px;align-items:center;margin:8px 0">
    <a class="btn" href="create.php">+ Nuevo componente</a>
    <form method="get" style="margin-left:auto;display:flex;gap:8px;align-items:center">
      <input class="input" name="q" placeholder="Buscar nombre o lote" value="<?=h($_GET['q']??'')?>">
      <button class="btn">Buscar</button>
      <a class="btn" href="index.php">Limpiar</a>
    </form>
  </div>
  <?php
    $q = trim($_GET['q'] ?? '');
    $where = ""; $params = [];
    if ($q !== '') { $where = "WHERE nombre LIKE ? OR lote LIKE ?"; $params = ["%$q%","%$q%"]; }
    $sql = "SELECT id,nombre,lote,vencimiento,precio_compra_g,precio_venta_g,estado FROM componentes $where ORDER BY nombre ASC LIMIT 1000";
    $st = $pdo->prepare($sql); $st->execute($params); $rows = $st->fetchAll();
  ?>
  <table class="table">
    <thead><tr>
      <th>Nombre</th><th>Lote</th><th>Vencimiento</th><th>$Compra/g</th><th>$Venta/g</th><th>Estado</th><th style="width:220px">Acciones</th>
    </tr></thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?=h($r['nombre'])?></td>
          <td><?=h($r['lote'])?></td>
          <td><?=h(fmt_date($r['vencimiento']))?></td>
          <td><?=h($r['precio_compra_g'])?></td>
          <td><?=h($r['precio_venta_g'])?></td>
          <td><?=h($r['estado'])?></td>
          <td>
            <a class="btn" href="edit.php?id=<?= (int)$r['id'] ?>">Editar</a>
            <a class="btn" href="delete.php?id=<?= (int)$r['id'] ?>" onclick="return confirm('¿Eliminar componente?')">Eliminar</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div></div>
</body></html>
