<?php require __DIR__.'/../../inc/bootstrap.php'; ?>
<!doctype html><html lang="es"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="../../assets/styles.css">
<link rel="stylesheet" href="../../assets/theme.css">
<title>Doctores</title></head><body>
<div class="container mini"><div class="card theme-doc">
  <a class="btn" href="../../index.php">&larr; Inicio</a>
  <h2>Doctores</h2>
  <div style="display:flex;gap:8px;align-items:center;margin:8px 0">
    <a class="btn" href="create.php">+ Nuevo doctor</a>
    <form method="get" style="margin-left:auto;display:flex;gap:8px;align-items:center">
      <input class="input" name="q" placeholder="Buscar nombre o RUT" value="<?=h($_GET['q']??'')?>">
      <button class="btn">Buscar</button>
      <a class="btn" href="index.php">Limpiar</a>
    </form>
  </div>
  <?php
    $q = trim($_GET['q'] ?? '');
    $where = ""; $params = [];
    if ($q !== '') { $where = "WHERE nombre LIKE ? OR rut LIKE ?"; $params = ["%$q%","%$q%"]; }
    $sql = "SELECT id,nombre,rut,especialidad,direccion,telefono FROM doctores $where ORDER BY nombre ASC LIMIT 1000";
    $st = $pdo->prepare($sql); $st->execute($params); $rows = $st->fetchAll();
  ?>
  <table class="table">
    <thead><tr>
      <th>Nombre</th><th>RUT</th><th>Especialidad</th><th>Dirección</th><th>Teléfono</th><th style="width:220px">Acciones</th>
    </tr></thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?=h($r['nombre'])?></td>
          <td><?=h($r['rut'])?></td>
          <td><?=h($r['especialidad'])?></td>
          <td><?=h($r['direccion'])?></td>
          <td><?=h($r['telefono'])?></td>
          <td>
            <a class="btn" href="edit.php?id=<?= (int)$r['id'] ?>">Editar</a>
            <a class="btn" href="delete.php?id=<?= (int)$r['id'] ?>" onclick="return confirm('¿Eliminar doctor?')">Eliminar</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div></div>
</body></html>
