<?php require __DIR__.'/../../inc/bootstrap.php'; 
$hoy = date('Y-m-d');
$venc = date('Y-m-d', strtotime('+40 days'));
?>
<!doctype html><html lang='es'><head>
<meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link rel='stylesheet' href='../../assets/styles.css'>
<link rel='stylesheet' href='../../assets/theme.css'>
<title>Nuevo preparado</title>
<style>
.two-pane { display:grid; grid-template-columns:1.2fr 1fr; gap:16px; align-items:start; }
.pane { display:grid; gap:12px; }
.pane .section { display:grid; gap:10px; }
.pane .grid-2 { display:grid; grid-template-columns:repeat(2,1fr); gap:12px; }
.pane-right { position:sticky; top:12px; }
@media (max-width: 960px){ .two-pane{grid-template-columns:1fr} .pane-right{position:static} }
.row-3cols-doc { display:grid; grid-template-columns: 2fr 0.9fr 1.4fr; gap:12px; }
.row-3cols-pac { display:grid; grid-template-columns: 2fr 0.9fr 1.7fr; gap:12px; }
@media (max-width: 720px){ .row-3cols-doc, .row-3cols-pac { grid-template-columns:1fr; } }
.autocomplete-wrap { position:relative; }
.autocomplete-list { position:absolute; left:0; right:0; top:100%; z-index:20; background:#fff; border:1px solid #cbd5e1; box-shadow:0 6px 20px rgba(0,0,0,.08); max-height:220px; overflow:auto; }
.autocomplete-item { padding:6px 8px; cursor:pointer; }
.autocomplete-item:hover { background:#e5f3ff; }
.card.theme-prep { padding:16px; }

/* Cabecera de columnas de Componentes (solo una vez) */
#comp-header {
  display:none;
  grid-template-columns: 2fr 1fr 1fr 1fr 1fr auto;
  gap:8px;
  font-size:12px;
  font-weight:600;
  color:#334155;
  align-items:end;
  margin-bottom:6px;
}
</style>
</head><body>
<div class='container mini'>
  <div class='card theme-prep'>
    <div style="display:flex;gap:8px;align-items:center;justify-content:space-between">
      <a class='btn' href='../../index.php'>← Volver</a>
      <a class='btn' href='list.php'>🧾 Listado</a>
    </div>
    <h2 style="margin:8px 0 12px">Preparado nuevo</h2>

    <form method='post' action='save.php' id="form-prep">
      <!-- IDs ocultos resueltos por auto-creación -->
      <input type="hidden" name="id_doctor" id="id_doctor" value="">
      <input type="hidden" name="id_paciente" id="id_paciente" value="">

      <div class="two-pane">
        <!-- ===== IZQUIERDA ===== -->
        <div class="pane pane-left">
          <!-- Doctor -->
          <div class="section">
            <h3 style="margin:0">Doctor</h3>
            <div class="row-3cols-doc">
              <div>
                <div class="label">Nombre doctor</div>
                <input class="input" name="dr_nombre" id="doctor_nombre" autocomplete="off" required>
              </div>
              <div>
                <div class="label">RUT Dr</div>
                <input class="input" name="dr_rut" id="doctor_rut" required>
              </div>
              <div>
                <div class="label">Especialidad</div>
                <input class="input" name="dr_especialidad" id="doctor_especialidad">
              </div>
            </div>
            <input type="hidden" name="dr_direccion" id="doctor_direccion" value="">
            <input type="hidden" name="dr_telefono"  id="doctor_telefono"  value="">
          </div>

          <!-- Paciente -->
          <div class="section">
            <h3 style="margin:0">Paciente</h3>
            <div class="row-3cols-pac">
              <div>
                <div class="label">Nombre Paciente</div>
                <input class="input" name="paciente_nombre" id="paciente_nombre" autocomplete="off" required>
              </div>
              <div>
                <div class="label">RUT Pac</div>
                <input class="input" name="paciente_rut" id="paciente_rut" required>
              </div>
              <div>
                <div class="label">Dirección Paciente</div>
                <input class="input" name="paciente_direccion" id="paciente_direccion">
              </div>
            </div>
            <div class="grid-2">
              <div>
                <div class="label">Teléfono</div>
                <input class="input" name="paciente_telefono" id="paciente_telefono">
              </div>
              <div>
                <div class="label">Mascota (opcional)</div>
                <input class="input" name="paciente_mascota" id="paciente_mascota">
              </div>
            </div>
          </div>

          <!-- Datos del preparado -->
          <div class="section">
            <h3 style="margin:0">Preparación</h3>
            <div class="grid-2">
              <div>
                <div class="label">N° externo</div>
                <input class="input" name="numero_externo" required>
              </div>
              <div>
                <div class="label">Destino</div>
                <input class="input" name="destino" placeholder="Veterinaria, Paciente, Clínica">
              </div>
              <div>
                <div class="label">Forma farmacéutica</div>
                <select class="input" name="forma_farmaceutica" id="forma_farmaceutica" required>
                  <option>Cápsulas</option><option>Polvo</option><option>Cremas</option><option>Shampoo</option>
                  <option>Gel</option><option>Ungüento</option><option>Loción</option><option>Laca</option>
                  <option>Spray</option><option>Gotas</option><option>Jarabe</option><option>supositorios</option>
                </select>
              </div>
              <div>
                <div class="label">Cantidad total (<span id="unidad_total">g</span>)</div>
                <input type="number" step="1" class="input" name="total" required>
              </div>
              <div>
                <div class="label">Fecha elaboración</div>
                <input class="input" type="date" name="fecha_elaboracion" value="<?=$hoy?>" required>
              </div>
              <div>
                <div class="label">Fecha vencimiento (+40 días)</div>
                <input class="input" type="date" name="fecha_vencimiento" value="<?=$venc?>" required>
              </div>
              <div>
                <div class="label">Valor sugerido</div>
                <input class="input" name="valor_sugerido" placeholder="Opcional">
              </div>
              <div>
                <div class="label">Lugar de entrega</div>
                <input class="input" name="lugar_entrega" placeholder="Sucursal o destino">
              </div>
            </div>
            <div>
              <div class="label">Excipiente</div>
              <input class="input" name="excipiente" placeholder="Excipiente del preparado">
            </div>
          </div>
        </div>

        <!-- ===== DERECHA ===== -->
        <div class="pane pane-right">
          <div class="section">
            <h3 style="margin:0">Componentes</h3>

            <!-- Cabecera única (solo se muestra si hay filas) -->
            <div id="comp-header" class="grid">
              <div>Componente</div>
              <div>Unidad</div>
              <div>Cantidad</div>
              <div>Costo compra g</div>
              <div>Precio venta g</div>
              <div></div>
            </div>

            <!-- Contenedor de filas -->
            <div id="componentes-rows"></div>

            <!-- Template SIN etiquetas por campo (solo placeholders) -->
            <template id="row-comp-template">
              <div class="row-comp grid" style="grid-template-columns: 2fr 1fr 1fr 1fr 1fr auto; align-items:end; margin-bottom:8px; gap:8px">
                <div>
                  <input class="input comp-nombre input-componente" name="comp_nombre[]" autocomplete="off" placeholder="Componente">
                </div>
                <div>
                  <select class="input um-comp" name="comp_um[]">
                    <option>mg</option><option>ug</option><option>UI</option>
                  </select>
                </div>
                <div>
                  <input class="input" type="number" step="1" name="comp_cantidad[]" placeholder="Cantidad">
                </div>
                <div>
                  <input class="input" type="number" step="0.01" name="comp_compra_g[]" placeholder="Compra g">
                </div>
                <div>
                  <input class="input" type="number" step="0.01" name="comp_venta_g[]" placeholder="Venta g">
                </div>
                <div><button class="btn del-comp" type="button" title="Eliminar">🗑️</button></div>
              </div>
            </template>

            <button type="button" class="btn add-comp">➕ Agregar componente</button>
          </div>

          <div class="section">
            <h3 style="margin:0">Acciones</h3>
            <div class="grid-2">
              <div><button class="btn" type="submit" name="redir" value="label">💾 Guardar y ver etiqueta</button></div>
              <div><button class="btn" type="submit" name="redir" value="list">💾 Guardar</button></div>
            </div>
            <small class="label">El valor calculado usa el precio de venta g, según forma y componentes.</small>
          </div>
        </div>
      </div>
    </form>
  </div>
</div>

<script>
// ==== API búsqueda (autocomplete) ====
async function apiSearch(type, q) {
  const r = await fetch(`../../api/search.php?type=${type}&q=${encodeURIComponent(q)}`);
  if (!r.ok) return [];
  return await r.json();
}
function attachAutocomplete(input, type, fill) {
  const wrap = document.createElement('div'); wrap.className = 'autocomplete-wrap';
  input.parentNode.insertBefore(wrap, input); wrap.appendChild(input);
  const list = document.createElement('div'); list.className = 'autocomplete-list'; list.style.display = 'none'; wrap.appendChild(list);
  input.addEventListener('input', async () => {
    const q = input.value.trim();
    if (q.length < 2) { list.style.display = 'none'; list.innerHTML=''; return; }
    const data = await apiSearch(type, q);
    list.innerHTML = '';
    data.forEach(it => {
      const div = document.createElement('div'); div.className = 'autocomplete-item'; div.textContent = it.label || it.nombre;
      div.onclick = () => {
        input.value = it.nombre || it.label; list.style.display = 'none';
        if (fill) Object.keys(fill).forEach(k => {
          const el = document.getElementById(fill[k]);
          if (el && it[k] !== undefined) el.value = it[k];
        });
        if (type === 'doctor' && it.id) { const h = document.getElementById('id_doctor'); if (h) h.value = it.id; }
        if (type === 'paciente' && it.id){ const h = document.getElementById('id_paciente'); if (h) h.value = it.id; }
      };
      list.appendChild(div);
    });
    list.style.display = data.length ? 'block' : 'none';
  });
  document.addEventListener('click', (e) => { if (!wrap.contains(e.target)) list.style.display = 'none'; });
}

// ==== Ajuste unidades por forma ====
function onFormaChange() {
  const forma = document.getElementById('forma_farmaceutica').value;
  const unidadTotal = document.getElementById('unidad_total');
  const umComp = document.querySelectorAll('.um-comp');
  const f = (s)=> (s||'').toLowerCase();

  let totalUnit = 'g', units = ['mg','ug','UI'];
  const vf = f(forma);
  if (['cremas','gel','ungüento'].includes(vf)) { totalUnit='g'; units=['%']; }
  else if (['loción','locion','laca','shampoo','spray'].includes(vf)) { totalUnit='ml'; units=['%']; }
  else if (['jarabe','gotas'].includes(vf)) { totalUnit='ml'; units=['mg/ml','%']; }
  else if (['cápsulas','capsulas'].includes(vf)) { totalUnit='cápsulas'; units=['mg','ug','UI']; }
  else if (['supositorios'].includes(vf)) { totalUnit='supositorios'; units=['mg']; }
  else if (['polvo'].includes(vf)) { totalUnit='g'; units=['mg','%']; }
  if (unidadTotal) unidadTotal.textContent = totalUnit;
  umComp.forEach(sel => { sel.innerHTML = ''; units.forEach(u => { const o=document.createElement('option'); o.value=u; o.textContent=u; sel.appendChild(o); }); });
}

// ==== Auto-crear Doctor/Paciente si no existen ====
async function postJSON(url, data){
  const res = await fetch(url, { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(data) });
  return await res.json();
}
function flashOK(el, ok){
  if(!el) return;
  el.style.outline = ok ? '2px solid #16a34a' : '2px solid #ef4444';
  setTimeout(()=>{ el.style.outline=''; }, 1200);
}

// Doctor
const drNombre = document.getElementById('doctor_nombre');
const drRut    = document.getElementById('doctor_rut');
const drEsp    = document.getElementById('doctor_especialidad');
const idDoctor = document.getElementById('id_doctor');

async function ensureDoctor(){
  const nombre = (drNombre?.value||'').trim();
  const rut    = (drRut?.value||'').trim();
  const especialidad = (drEsp?.value||'').trim();
  if (!nombre && !rut) return;
  try{
    const r = await postJSON('../ajax/find_or_create_doctor.php', { nombre, rut, especialidad });
    if (r.ok) { if (idDoctor) idDoctor.value = r.id; flashOK(drNombre||drRut, true); }
    else { console.error(r.error); flashOK(drNombre||drRut, false); }
  }catch(e){ console.error(e); flashOK(drNombre||drRut, false); }
}
if (drRut)    drRut.addEventListener('blur', ensureDoctor);
if (drNombre) drNombre.addEventListener('blur', ensureDoctor);

// Paciente
const paNombre = document.getElementById('paciente_nombre');
const paRut    = document.getElementById('paciente_rut');
const paDir    = document.getElementById('paciente_direccion');
const paTel    = document.getElementById('paciente_telefono');
const paMasc   = document.getElementById('paciente_mascota');
const idPaciente = document.getElementById('id_paciente');

async function ensurePaciente(){
  const nombre = (paNombre?.value||'').trim();
  const rut    = (paRut?.value||'').trim();
  const direccion = (paDir?.value||'').trim();
  const telefono  = (paTel?.value||'').trim();
  const mascota   = (paMasc?.value||'').trim();
  if (!nombre && !rut) return;
  try{
    const r = await postJSON('../ajax/find_or_create_paciente.php', { nombre, rut, direccion, telefono, mascota });
    if (r.ok) { if (idPaciente) idPaciente.value = r.id; flashOK(paNombre||paRut, true); }
    else { console.error(r.error); flashOK(paNombre||paRut, false); }
  }catch(e){ console.error(e); flashOK(paNombre||paRut, false); }
}
if (paRut)    paRut.addEventListener('blur', ensurePaciente);
if (paNombre) paNombre.addEventListener('blur', ensurePaciente);

// ==== Componentes dinámicos con cabecera única ====
function ensureCompHeader(){
  const rows = document.querySelectorAll('#componentes-rows .row-comp').length;
  const header = document.getElementById('comp-header');
  if (header) header.style.display = rows > 0 ? 'grid' : 'none';
}
function addCompRow(focus=true){
  const tpl = document.getElementById('row-comp-template');
  const cont = document.getElementById('componentes-rows');
  cont.insertAdjacentHTML('beforeend', tpl.innerHTML);
  setTimeout(() => {
    const inputs = cont.querySelectorAll('.input-componente');
    const last = inputs[inputs.length - 1];
    if (last && !last.dataset.acBound) {
      last.dataset.acBound='1';
      attachAutocomplete(last, 'componente', null);
      if (focus) last.focus();
    }
    onFormaChange();
    ensureCompHeader();
  }, 10);
}
document.addEventListener('click', (e) => {
  if (e.target.matches('.add-comp')) addCompRow(true);
  if (e.target.matches('.del-comp')) {
    const row = e.target.closest('.row-comp'); if (row) row.remove();
    ensureCompHeader();
  }
});

document.addEventListener('DOMContentLoaded', () => {
  onFormaChange();
  document.getElementById('forma_farmaceutica').addEventListener('change', onFormaChange);

  attachAutocomplete(document.getElementById('doctor_nombre'),'doctor',{rut:'doctor_rut',especialidad:'doctor_especialidad',direccion:'doctor_direccion',telefono:'doctor_telefono'});
  attachAutocomplete(document.getElementById('paciente_nombre'),'paciente',{rut:'paciente_rut',direccion:'paciente_direccion',telefono:'paciente_telefono',mascota:'paciente_mascota'});

  // Primera fila por defecto y muestra cabecera
  addCompRow(false);
  ensureCompHeader();

  // Antes de enviar: garantiza IDs creados
  const form = document.getElementById('form-prep');
  form.addEventListener('submit', async (e)=>{
    if (!idDoctor.value)  await ensureDoctor();
    if (!idPaciente.value) await ensurePaciente();
  }, {capture:true});
});
</script>
</body></html>

