<?php
require __DIR__.'/../../inc/bootstrap.php';
$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT p.*, pa.nombre AS pac, pa.mascota, d.nombre AS doc
  FROM preparados p
  JOIN pacientes pa ON pa.id=p.id_paciente
  JOIN doctores d ON d.id=p.id_doctor
  WHERE p.id=?");
$stmt->execute([$id]); $p = $stmt->fetch();
if(!$p){ http_response_code(404); echo "No encontrado"; exit; }
$det = $pdo->prepare("SELECT nombre_componente, unidad_medida, cantidad FROM componentes_preparado WHERE id_preparado=?");
$det->execute([$id]); $comps = $det->fetchAll();

$u = 'GRS'; $forma = $p['forma_farmaceutica'];
if($forma==='cápsulas'){ $u='capsulas'; }
elseif(in_array($forma,['Jarabe','gotas','Locion','laca','shampoo','spray'])){ $u='ML'; }
elseif(in_array($forma,['cremas','polvo','Gel','Ungüento'])){ $u='GRS'; }

$col1 = array_slice($comps, 0, 6);
$col2 = array_slice($comps, 6);

function qty3($x){ $q=(string)((int)$x); return substr($q,0,3); }
function comp10($s){
  $s = trim((string)$s);
  if (function_exists('mb_strimwidth')) { $s = mb_strimwidth($s, 0, 10, ''); }
  else { $s = substr($s, 0, 10); }
  return str_pad($s, 10, ' ');
}
?>
<!doctype html><html lang='es'><head><meta charset='utf-8'><meta name='viewport' content='width=device-width,initial-scale=1'>
<link rel='stylesheet' href='../../assets/styles.css'><title>Etiqueta</title></head><body>
<style>@page { size: Letter; margin: 10mm; } .label-top-left{position:absolute;top:0;left:0}</style>

<div class='container'>
  <div class='no-print'><a class='btn' href='list.php'>← Volver</a> <button class='btn' onclick='window.print()'>🖨️ Imprimir</button></div>
  <div class='label-101x34 label-top-left'>
    <div>
      <div class='ff'><?=h($p['forma_farmaceutica'])?></div>
      <?php foreach($col1 as $c): ?>
        <div class='comp'><span class='comp-name'><?=h(comp10($c['nombre_componente']))?></span>: <span class='qty'><?=qty3($c['cantidad'])?></span> <?=h($c['unidad_medida'])?></div>
      <?php endforeach; ?>
    </div>
    <div>
      <?php foreach($col2 as $c): ?>
        <div class='comp'><span class='comp-name'><?=h(comp10($c['nombre_componente']))?></span>: <span class='qty'><?=qty3($c['cantidad'])?></span> <?=h($c['unidad_medida'])?></div>
      <?php endforeach; ?>
      <div class='comp ff' style='margin-top:4px'>Total: <span class='qty'><?= (int)$p['total'] ?></span> <?=$u?></div>
    </div>
    <div>
      <div>Doc: <?=h($p['doc'])?></div>
      <div>Pac: <?=h($p['pac'])?> <?= $p['mascota'] ? "(Mascota: ".h($p['mascota']).")" : "" ?></div>
      <div>F. Elab.: <?=h(fmt_date($p['fecha_elaboracion']))?></div>
      <div>F. Venc.: <?=h(fmt_date($p['fecha_vencimiento']))?></div>
      <div class='azul' style='margin-top:4px'>QF NINOSKA FRANCO</div>
      <div class='rojo-small'>DOSIS INDICACION MEDICA</div>
    </div>
    <div class='footer-azul'>Mantener fuera del alcance de los niños. Conservar en lugar fresco y seco. Nota: Eliminar después del vencimiento. RESOLUCION RF XIII 05/20 1A,1B y 2C FARMAVIDA, Recoleta 5418</div>
  </div>
</div>
</body></html>