<?php
ob_start();
$autoload = __DIR__ . '/../../../vendor/autoload.php';
require_once $autoload;
ob_end_clean();

use Dompdf\Dompdf;
use Dompdf\Options;

$html = '<!doctype html><html><head>
<meta charset="utf-8">
<style>
  @page { size: 101mm 34mm; margin: 0; }
  html, body { margin:0; padding:0; }
  .box { width:101mm; height:34mm; box-sizing:border-box; padding:2mm; font:12px DejaVu Sans, Arial; }
  .box * { margin:0 !important; padding:0 !important; }
  .area { width:97mm; height:28mm; background:#eee; }
</style>
</head><body>
  <div class="box"><div class="area">SMOKE TEST 101x34</div></div>
</body></html>';

$opt = new Options();
$opt->set('isHtml5ParserEnabled', true);
$dompdf = new Dompdf($opt);
while (ob_get_level()) ob_end_clean();
$dompdf->setPaper([0,0,101*2.83465,34*2.83465], 'portrait');
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->render();
$dompdf->stream('smoke.pdf', ['Attachment'=>false]);
