<?php
require __DIR__.'/../../inc/bootstrap.php';

function as_int($v){ return (int)preg_replace('/[^\d-]/','',(string)$v); }
function norm($v){ return trim((string)$v); }
function ymd_or_null($v){
  $v = trim((string)$v);
  if ($v==='') return null;
  if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$v)) return $v;
  if (preg_match('/^(\d{2})-(\d{2})-(\d{4})$/',$v,$m)) return "{$m[3]}-{$m[2]}-{$m[1]}";
  return $v;
}

// Doctor
$dr_nombre = norm($_POST['dr_nombre'] ?? '');
$dr_rut    = norm($_POST['dr_rut'] ?? '');
$dr_esp    = norm($_POST['dr_especialidad'] ?? '');
// Paciente
$pac_nombre = norm($_POST['paciente_nombre'] ?? '');
$pac_rut    = norm($_POST['paciente_rut'] ?? '');
$pac_dir    = norm($_POST['paciente_direccion'] ?? '');
$pac_tel    = norm($_POST['paciente_telefono'] ?? '');
$pac_masc   = norm($_POST['paciente_mascota'] ?? '');
// Preparado
$numero_externo = norm($_POST['numero_externo'] ?? '');
$destino        = norm($_POST['destino'] ?? '');
$forma          = norm($_POST['forma_farmaceutica'] ?? '');
$total          = as_int($_POST['total'] ?? 0);
$fecha_elab     = ymd_or_null($_POST['fecha_elaboracion'] ?? '');
$fecha_venc     = ymd_or_null($_POST['fecha_vencimiento'] ?? '');
$excipiente     = norm($_POST['excipiente'] ?? '');
$valor_sugerido = norm($_POST['valor_sugerido'] ?? '');

// Componentes
$comp_ids      = $_POST['comp_id']       ?? []; // puede venir vacío
$comp_nombres  = $_POST['comp_nombre']   ?? [];
$comp_ums      = $_POST['comp_um']       ?? [];
$comp_cants    = $_POST['comp_cantidad'] ?? [];
$comp_compra_g = $_POST['comp_compra_g'] ?? [];
$comp_venta_g  = $_POST['comp_venta_g']  ?? [];

if ($dr_nombre==='' || $dr_rut==='' || $pac_nombre==='' || $pac_rut==='' || $numero_externo==='' || $forma==='' || $total<=0) {
  http_response_code(400); echo "Faltan datos obligatorios."; exit;
}

try {
  $pdo->beginTransaction();

  // Doctor por RUT
  $q=$pdo->prepare("SELECT id FROM doctores WHERE rut=?"); $q->execute([$dr_rut]); $doc_id=$q->fetchColumn();
  if (!$doc_id) {
    $pdo->prepare("INSERT INTO doctores (nombre,rut,especialidad) VALUES (?,?,?)")->execute([$dr_nombre,$dr_rut,$dr_esp]);
    $doc_id = (int)$pdo->lastInsertId();
  } else {
    $pdo->prepare("UPDATE doctores SET nombre=?,especialidad=? WHERE id=?")->execute([$dr_nombre,$dr_esp,$doc_id]);
  }

  // Paciente por RUT
  $q=$pdo->prepare("SELECT id FROM pacientes WHERE rut=?"); $q->execute([$pac_rut]); $pac_id=$q->fetchColumn();
  if (!$pac_id) {
    $pdo->prepare("INSERT INTO pacientes (nombre,rut,direccion,telefono,mascota) VALUES (?,?,?,?,?)")
        ->execute([$pac_nombre,$pac_rut,$pac_dir,$pac_tel,$pac_masc]);
    $pac_id = (int)$pdo->lastInsertId();
  } else {
    $pdo->prepare("UPDATE pacientes SET nombre=?,direccion=?,telefono=?,mascota=? WHERE id=?")
        ->execute([$pac_nombre,$pac_dir,$pac_tel,$pac_masc,$pac_id]);
  }

  // Unidad total (para etiqueta)
  $unidad_total = 'GRS';
  if ($forma==='cápsulas') $unidad_total='capsulas';
  elseif (in_array($forma,['Jarabe','gotas','Locion','laca','shampoo','spray'])) $unidad_total='ML';
  elseif ($forma==='supositorios') $unidad_total='supositorios';

  // Cálculo valor_calculado (usa venta_g)
  $ENV_CAP=4000; $ENV_CRE=5000; $ENV_LOC=5000; $valor_calc=0.0;
  $count = max(count($comp_nombres),count($comp_ums),count($comp_cants),count($comp_venta_g));
  for($i=0;$i<$count;$i++){
    $name=norm($comp_nombres[$i]??''); $um=norm($comp_ums[$i]??''); $cant=(int)($comp_cants[$i]??0); $pv=(float)($comp_venta_g[$i]??0);
    if($name==='' || $cant<=0) continue;

    if($forma==='cápsulas'){
      $g=0.0;
      if($um==='mg') $g=($cant/1000.0)*$total;
      elseif($um==='ug') $g=($cant/1000000.0)*$total;
      elseif($um==='UI') $g=0.0;
      else $g=$cant;
      if($pv>0) $valor_calc += $pv*$g;
    } elseif(in_array($forma,['cremas','Gel','Ungüento'])){
      if($um==='%'){ $g=($cant*$total)/100.0; if($pv>0)$valor_calc+=$pv*$g; }
    } elseif(in_array($forma,['Locion','laca'])){
      if($um==='%'){ $g=($cant*$total)/100.0; if($pv>0)$valor_calc+=$pv*$g; }
    } elseif(in_array($forma,['Jarabe','gotas'])){
      if($um==='mg/ml'){ $g=($cant*$total)/1000.0; if($pv>0)$valor_calc+=$pv*$g; }
      elseif($um==='%'){ $g=($cant*$total)/100.0; if($pv>0)$valor_calc+=$pv*$g; }
    } elseif($forma==='supositorios'){
      if($um==='mg'){ $g=($cant/1000.0)*$total; if($pv>0)$valor_calc+=$pv*$g; }
    } elseif($forma==='polvo'){
      if($um==='mg'){ $g=($cant/1000.0); if($pv>0)$valor_calc+=$pv*$g; }
      elseif($um==='%'){ $g=($cant*$total)/100.0; if($pv>0)$valor_calc+=$pv*$g; }
    } else {
      if($pv>0) $valor_calc += $pv*$cant;
    }
  }
  if($forma==='cápsulas') $valor_calc+=$ENV_CAP;
  elseif(in_array($forma,['cremas','Gel','Ungüento'])) $valor_calc+=$ENV_CRE;
  elseif(in_array($forma,['Locion','laca'])) $valor_calc+=$ENV_LOC;

  $valor_calc = (int)round($valor_calc);
  $valor_real = ($valor_sugerido!=='' && is_numeric($valor_sugerido)) ? (int)round((float)$valor_sugerido) : $valor_calc;

  // Insert preparado
  $insP = $pdo->prepare("INSERT INTO preparados
    (numero_externo,id_doctor,id_paciente,destino,total,unidad_medida,excipiente,forma_farmaceutica,valor_calculado,valor_real,fecha_elaboracion,fecha_vencimiento)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
  $insP->execute([$numero_externo,$doc_id,$pac_id,$destino,$total,$unidad_total,$excipiente,$forma,$valor_calc,$valor_real,$fecha_elab,$fecha_venc]);
  $prep_id = (int)$pdo->lastInsertId();

  // Resolver id_componente y guardar detalle
  $selComp = $pdo->prepare("SELECT id, precio_compra_g, precio_venta_g FROM componentes WHERE nombre=? LIMIT 1");
  $insComp = $pdo->prepare("INSERT INTO componentes (nombre, lote, vencimiento, precio_compra_g, precio_venta_g, estado) VALUES (?,?,?,?,?,?)");
  $insDet  = $pdo->prepare("INSERT INTO componentes_preparado
    (id_preparado, id_componente, unidad_medida, cantidad, compra_g, venta_g)
    VALUES (?,?,?,?,?,?)");

  for($i=0;$i<$count;$i++){
    $name = norm($comp_nombres[$i] ?? '');
    $um   = norm($comp_ums[$i]     ?? '');
    $cant = (int)($comp_cants[$i]  ?? 0);
    $pc   = (float)($comp_compra_g[$i] ?? 0);
    $pv   = (float)($comp_venta_g[$i]  ?? 0);
    if($name==='' || $cant<=0) continue;

    // Si vino comp_id[] úsalo, si no, resolver por nombre (y crear si no existe)
    $cid = (int)($comp_ids[$i] ?? 0);
    if ($cid <= 0) {
      $selComp->execute([$name]); $row = $selComp->fetch();
      if ($row) {
        $cid = (int)$row['id'];
        // si no ingresaste pc/pv en el form, toma de maestro (opcional)
        if ($pc<=0 && $row['precio_compra_g']>0) $pc = (float)$row['precio_compra_g'];
        if ($pv<=0 && $row['precio_venta_g']>0)  $pv = (float)$row['precio_venta_g'];
      } else {
        $insComp->execute([$name, null, null, $pc, $pv, 'en uso']);
        $cid = (int)$pdo->lastInsertId();
      }
    }

    $insDet->execute([$prep_id, $cid, $um, $cant, $pc, $pv]);
  }

  $pdo->commit();

  $redir = $_POST['redir'] ?? 'list';
  if ($redir==='label') header("Location: label_preview.php?id=".$prep_id);
  else header("Location: list.php?created=1");
  exit;

} catch(Throwable $e){
  if($pdo->inTransaction()) $pdo->rollBack();
  http_response_code(500); echo "Error al crear preparado: ".$e->getMessage();
}
