<?php
require __DIR__.'/../../inc/bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405); echo "Método no permitido"; exit;
}

$pdo->beginTransaction();
try {
  $id = (int)($_POST['id'] ?? 0);
  if(!$id) throw new Exception("ID de preparado inválido");

  // ===== DOCTOR: find-or-create si no viene id =====
  $id_doctor = (int)($_POST['id_doctor'] ?? 0);
  $dr_nombre = trim($_POST['dr_nombre'] ?? '');
  $dr_rut    = trim($_POST['dr_rut'] ?? '');
  $dr_espec  = trim($_POST['dr_especialidad'] ?? '');
  if (!$id_doctor) {
    // Prioridad por RUT, si no por nombre exacto
    if ($dr_rut !== '') {
      $s = $pdo->prepare("SELECT id FROM doctores WHERE rut=? LIMIT 1");
      $s->execute([$dr_rut]); $row = $s->fetch();
      if ($row) $id_doctor = (int)$row['id'];
    }
    if (!$id_doctor && $dr_nombre !== '') {
      $s = $pdo->prepare("SELECT id FROM doctores WHERE nombre=? LIMIT 1");
      $s->execute([$dr_nombre]); $row = $s->fetch();
      if ($row) $id_doctor = (int)$row['id'];
    }
    if (!$id_doctor) {
      $ins = $pdo->prepare("INSERT INTO doctores (nombre, rut, especialidad) VALUES (?,?,?)");
      $ins->execute([$dr_nombre, $dr_rut, $dr_espec]);
      $id_doctor = (int)$pdo->lastInsertId();
    } else {
      // opcional: actualizar campos no vacíos
      $upd = $pdo->prepare("UPDATE doctores SET nombre=?, rut=?, especialidad=? WHERE id=?");
      $upd->execute([$dr_nombre, $dr_rut, $dr_espec, $id_doctor]);
    }
  }

  // ===== PACIENTE: find-or-create si no viene id =====
  $id_paciente = (int)($_POST['id_paciente'] ?? 0);
  $pa_nombre = trim($_POST['paciente_nombre'] ?? '');
  $pa_rut    = trim($_POST['paciente_rut'] ?? '');
  $pa_dir    = trim($_POST['paciente_direccion'] ?? '');
  $pa_tel    = trim($_POST['paciente_telefono'] ?? '');
  $pa_masc   = trim($_POST['paciente_mascota'] ?? '');
  if (!$id_paciente) {
    if ($pa_rut !== '') {
      $s = $pdo->prepare("SELECT id FROM pacientes WHERE rut=? LIMIT 1");
      $s->execute([$pa_rut]); $row = $s->fetch();
      if ($row) $id_paciente = (int)$row['id'];
    }
    if (!$id_paciente && $pa_nombre !== '') {
      $s = $pdo->prepare("SELECT id FROM pacientes WHERE nombre=? LIMIT 1");
      $s->execute([$pa_nombre]); $row = $s->fetch();
      if ($row) $id_paciente = (int)$row['id'];
    }
    if (!$id_paciente) {
      $ins = $pdo->prepare("INSERT INTO pacientes (nombre, rut, direccion, telefono, mascota) VALUES (?,?,?,?,?)");
      $ins->execute([$pa_nombre, $pa_rut, $pa_dir, $pa_tel, $pa_masc]);
      $id_paciente = (int)$pdo->lastInsertId();
    } else {
      $upd = $pdo->prepare("UPDATE pacientes SET nombre=?, rut=?, direccion=?, telefono=?, mascota=? WHERE id=?");
      $upd->execute([$pa_nombre, $pa_rut, $pa_dir, $pa_tel, $pa_masc, $id_paciente]);
    }
  }

  // ===== CAMPOS PREPARADO =====
  $numero_externo     = trim($_POST['numero_externo'] ?? '');
  $destino            = trim($_POST['destino'] ?? '');
  $forma_farmaceutica = trim($_POST['forma_farmaceutica'] ?? '');
  $total              = (int)($_POST['total'] ?? 0);
  $fecha_elab         = substr(trim($_POST['fecha_elaboracion'] ?? ''),0,10);
  $fecha_venc         = substr(trim($_POST['fecha_vencimiento'] ?? ''),0,10);
  $valor_sugerido     = trim($_POST['valor_sugerido'] ?? '');
  $lugar_entrega      = trim($_POST['lugar_entrega'] ?? '');
  $excipiente         = trim($_POST['excipiente'] ?? '');

  $updP = $pdo->prepare("UPDATE preparados SET 
      numero_externo=?,
      id_doctor=?,
      id_paciente=?,
      destino=?,
      total=?,
      forma_farmaceutica=?,
      excipiente=?,
      fecha_elaboracion=?,
      fecha_vencimiento=?,
      valor_sugerido=?,
      lugar_entrega=?
    WHERE id=?");
  $updP->execute([
    $numero_externo,
    $id_doctor,
    $id_paciente,
    $destino,
    $total,
    $forma_farmaceutica,
    $excipiente,
    $fecha_elab,
    $fecha_venc,
    $valor_sugerido,
    $lugar_entrega,
    $id
  ]);

  // ===== COMPONENTES: estrategia simple → borrar e insertar de nuevo =====
  $del = $pdo->prepare("DELETE FROM componentes_preparado WHERE id_preparado=?");
  $del->execute([$id]);

  $nombres   = $_POST['comp_nombre']   ?? [];
  $ums       = $_POST['comp_um']       ?? [];
  $cantidades= $_POST['comp_cantidad'] ?? [];
  $compras   = $_POST['comp_compra_g'] ?? [];
  $ventas    = $_POST['comp_venta_g']  ?? [];

  $selComp = $pdo->prepare("SELECT id FROM componentes WHERE nombre=? LIMIT 1");
  $insComp = $pdo->prepare("INSERT INTO componentes (nombre, lote, vencimiento, precio_compra_g, precio_venta_g, estado) VALUES (?, '', NULL, 0, 0, 'uso')");
  $insCP   = $pdo->prepare("
      INSERT INTO componentes_preparado
        (id_preparado, id_componente, unidad_medida, cantidad, compra_g, venta_g)
      VALUES (?,?,?,?,?,?)
  ");

  $rows = max(count($nombres), count($ums), count($cantidades));
  for($i=0; $i<$rows; $i++){
    $nombre = trim($nombres[$i] ?? '');
    if ($nombre==='') continue;
    $um     = trim($ums[$i] ?? '');
    $cant   = (int)($cantidades[$i] ?? 0);
    $cg     = (float)($compras[$i] ?? 0);
    $vg     = (float)($ventas[$i] ?? 0);

    // resolver id_componente (find-or-create por nombre)
    $selComp->execute([$nombre]);
    $row = $selComp->fetch();
    $id_comp = 0;
    if ($row) {
      $id_comp = (int)$row['id'];
    } else {
      $insComp->execute([$nombre]);
      $id_comp = (int)$pdo->lastInsertId();
    }

    $insCP->execute([$id, $id_comp, $um, $cant, $cg, $vg]);
  }

  $pdo->commit();

  $redir = $_POST['redir'] ?? 'list';
  if ($redir === 'label') {
    header("Location: label_preview.php?id=".$id);
  } else {
    header("Location: list.php");
  }
  exit;

} catch (Exception $e) {
  $pdo->rollBack();
  http_response_code(500);
  echo "Error al actualizar: " . h($e->getMessage());
  exit;
}
