<?php
// public/tools/backup.php
require __DIR__.'/../../inc/bootstrap.php';
/*
 * Exporta un dump simple de las tablas:
 *  doctores, pacientes, componentes, preparados, componentes_preparado
 * Modo: ?format=sql (default) o ?format=csv
 */

$format = strtolower($_GET['format'] ?? 'sql');
$fname = 'backup_'.date('Y-m-d_His');

$tables = [
  'doctores' => ['id','nombre','rut','especialidad','direccion','telefono'],
  'pacientes' => ['id','nombre','rut','direccion','telefono','mascota'],
  'componentes' => ['id','nombre','lote','vencimiento','precio_compra_g','precio_venta_g','estado'],
  'preparados' => ['id','numero_externo','id_doctor','id_paciente','destino','total','unidad_medida','excipiente','forma_farmaceutica','valor_calculado','valor_real','fecha_elaboracion','fecha_vencimiento'],
  'componentes_preparado' => ['id','id_preparado','nombre_componente','unidad_medida','cantidad','precio_venta_g']
];

if ($format === 'csv') {
  header('Content-Type: text/csv; charset=UTF-8');
  header('Content-Disposition: attachment; filename="'.$fname.'.zip"');

  // empaquetar CSVs en un ZIP en memoria
  $zip = new ZipArchive();
  $tmp = tempnam(sys_get_temp_dir(), 'zip');
  $zip->open($tmp, ZipArchive::OVERWRITE);

  foreach ($tables as $t=>$cols) {
    $stmt = $pdo->query("SELECT ".implode(',', $cols)." FROM $t");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $csv = fopen('php://temp','r+');
    fputcsv($csv, $cols);
    foreach($rows as $r){ fputcsv($csv, array_map(fn($c)=>$r[$c], $cols)); }
    rewind($csv);
    $data = stream_get_contents($csv);
    fclose($csv);
    $zip->addFromString($t.'.csv', $data);
  }

  $zip->close();
  readfile($tmp);
  @unlink($tmp);
  exit;
}

// SQL (por defecto)
header('Content-Type: application/sql; charset=UTF-8');
header('Content-Disposition: attachment; filename="'.$fname.'.sql"');

echo "-- Backup sencillo generado ".date('c')."\n";
echo "SET NAMES utf8mb4;\nSET FOREIGN_KEY_CHECKS=0;\n\n";

/* Esquemas mínimos (ajusta si tu schema difiere) */
echo "-- Esquemas mínimos\n";
echo "CREATE TABLE IF NOT EXISTS doctores (id INT PRIMARY KEY, nombre VARCHAR(255), rut VARCHAR(50), especialidad VARCHAR(100), direccion VARCHAR(255), telefono VARCHAR(50));\n";
echo "CREATE TABLE IF NOT EXISTS pacientes (id INT PRIMARY KEY, nombre VARCHAR(255), rut VARCHAR(50), direccion VARCHAR(255), telefono VARCHAR(50), mascota VARCHAR(100));\n";
echo "CREATE TABLE IF NOT EXISTS componentes (id INT PRIMARY KEY, nombre VARCHAR(255), lote VARCHAR(100), vencimiento DATE, precio_compra_g DECIMAL(12,2), precio_venta_g DECIMAL(12,2), estado VARCHAR(50));\n";
echo "CREATE TABLE IF NOT EXISTS preparados (id INT PRIMARY KEY, numero_externo VARCHAR(50), id_doctor INT, id_paciente INT, destino VARCHAR(150), total INT, unidad_medida VARCHAR(20), excipiente VARCHAR(255), forma_farmaceutica VARCHAR(50), valor_calculado INT, valor_real INT, fecha_elaboracion DATE, fecha_vencimiento DATE);\n";
echo "CREATE TABLE IF NOT EXISTS componentes_preparado (id INT PRIMARY KEY, id_preparado INT, nombre_componente VARCHAR(255), unidad_medida VARCHAR(30), cantidad INT, precio_venta_g DECIMAL(12,2));\n\n";

echo "-- Datos\n";
foreach ($tables as $t=>$cols) {
  $stmt = $pdo->query("SELECT ".implode(',', $cols)." FROM $t");
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
  if (!$rows) continue;
  foreach ($rows as $r) {
    $vals = [];
    foreach ($cols as $c) {
      $v = $r[$c];
      if ($v === null) { $vals[] = "NULL"; continue; }
      if (is_numeric($v) && preg_match('/^-?\d+(\.\d+)?$/', (string)$v)) {
        $vals[] = $v;
      } else {
        $vals[] = $pdo->quote($v);
      }
    }
    echo "INSERT INTO $t (".implode(',', $cols).") VALUES (".implode(',', $vals).");\n";
  }
  echo "\n";
}

echo "SET FOREIGN_KEY_CHECKS=1;\n";
