<?php
// public/tools/reset_admin.php
require_once __DIR__.'/../inc/bootstrap.php';

/** Utilidades */
function table_exists(PDO $pdo, string $table): bool {
  $st = $pdo->prepare("SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? LIMIT 1");
  $st->execute([$table]);
  return (bool)$st->fetchColumn();
}
function col_exists(PDO $pdo, string $table, string $col): bool {
  $st = $pdo->prepare("SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ? LIMIT 1");
  $st->execute([$table, $col]);
  return (bool)$st->fetchColumn();
}
function ensure_users_table(PDO $pdo){
  if (!table_exists($pdo, 'users')) {
    $pdo->exec("CREATE TABLE users (
      id INT AUTO_INCREMENT PRIMARY KEY,
      username VARCHAR(60) UNIQUE NOT NULL,
      password_hash VARCHAR(255) NULL,
      pass_hash VARCHAR(255) NULL,
      rol VARCHAR(20) NULL,
      activo TINYINT(1) NULL
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    return;
  }
  // Asegurar columnas clave
  if (!col_exists($pdo,'users','password_hash')) {
    $pdo->exec("ALTER TABLE users ADD COLUMN password_hash VARCHAR(255) NULL");
  }
  if (!col_exists($pdo,'users','pass_hash')) {
    $pdo->exec("ALTER TABLE users ADD COLUMN pass_hash VARCHAR(255) NULL");
  }
  if (!col_exists($pdo,'users','rol')) {
    $pdo->exec("ALTER TABLE users ADD COLUMN rol VARCHAR(20) NULL");
  }
  if (!col_exists($pdo,'users','activo')) {
    $pdo->exec("ALTER TABLE users ADD COLUMN activo TINYINT(1) NULL");
  }
  // Asegurar índice único en username
  try {
    $pdo->exec("CREATE UNIQUE INDEX ux_users_username ON users(username)");
  } catch (Throwable $e) {
    // probablemente ya exista; ignorar
  }
}
function password_col(PDO $pdo): string {
  // Prefiere password_hash; si no existe, usa pass_hash
  if (col_exists($pdo,'users','password_hash')) return 'password_hash';
  if (col_exists($pdo,'users','pass_hash'))     return 'pass_hash';
  // (no debería pasar porque ensure_users_table la crea) pero por si acaso:
  $pdo->exec("ALTER TABLE users ADD COLUMN password_hash VARCHAR(255) NULL");
  return 'password_hash';
}

/** Ejecutar */
try {
  ensure_users_table($pdo);
  $col = password_col($pdo);
  $hash = password_hash('admin123', PASSWORD_DEFAULT);

  // Upsert admin
  $st = $pdo->prepare("SELECT id FROM users WHERE username = 'admin' LIMIT 1");
  $st->execute();
  $id = $st->fetchColumn();

  if ($id) {
    $sql = "UPDATE users SET {$col} = :h, rol = COALESCE(rol,'admin'), activo = COALESCE(activo,1) WHERE id = :id";
    $ok  = $pdo->prepare($sql)->execute([':h'=>$hash, ':id'=>$id]);
  } else {
    // Insert con columnas presentes
    $fields = ['username', $col, 'rol', 'activo'];
    $place  = [':u', ':h', ':r', ':a'];
    $sql = "INSERT INTO users (".implode(',',$fields).") VALUES (".implode(',',$place).")";
    $ok  = $pdo->prepare($sql)->execute([':u'=>'admin', ':h'=>$hash, ':r'=>'admin', ':a'=>1]);
  }

  // Mostrar estado
  header('Content-Type: text/plain; charset=utf-8');
  if ($ok) {
    echo "OK: Usuario 'admin' listo o reseteado.\n";
    echo "Usuario: admin\nClave:   admin123\nRol:     admin\nActivo:  1\n";
    echo "IMPORTANTE: Borra este archivo (public/tools/reset_admin.php) después de usarlo.\n";
  } else {
    echo "ERROR creando/actualizando usuario.\n";
  }
} catch (Throwable $e) {
  header('Content-Type: text/plain; charset=utf-8');
  echo "ERROR: ".$e->getMessage()."\n";
}

