<?php
// tools/create_admin.php
$boot = realpath(__DIR__ . '/../public/inc/bootstrap.php');
if (!$boot || !is_file($boot)) {
    header('Content-Type: text/plain; charset=utf-8');
    http_response_code(500);
    echo "No se encontró bootstrap.php en: " . (__DIR__ . "/../public/inc/bootstrap.php");
    exit;
}
require_once $boot;

// Cambia estos valores antes de ejecutar:
$username = 'admin';
$email    = 'admin@example.com';
$password = 'admin123';
$role     = 'admin';

$hash = password_hash($password, PASSWORD_DEFAULT);

try {
    $stmt = $pdo->prepare("INSERT INTO usuarios (username, email, pass_hash, role, is_active) VALUES (?,?,?,?,1)
                           ON DUPLICATE KEY UPDATE email=VALUES(email), role=VALUES(role)");
    $stmt->execute([$username, $email, $hash, $role]);
    echo "OK - Usuario admin creado/actualizado.\n";
} catch(Exception $e){
    echo "ERROR: ".$e->getMessage()."\n";
}
